function A=fillSparse(D)
% FillSparse fills a sparse matrix with missing values (NaN) with row an column means
% SYNOPSIS
%    A=fillSparse(D)
% Despription
% D is input matrix
% A is output(filled matrix)
[rows,cols]=size(D);
K=isnan(D);
for r=1:rows
   for c=1:cols
      if K(r,c)==1
         row=D(r,:);
         rm=mean(row(K(r,:)~=1));
         col=D(:,c);
         cm=mean(col(K(:,c)~=1));
         A(r,c)=(rm+cm)/2;
      else
         A(r,c)=D(r,c);
      end;
   end;
end;