function v = isincluded(Subset, Set)
% ISINCLUDED (SetA, SetB):
% Which elements of SetB are included in SetA? 
% 
% returns a vector v of length(SetB) 
% logical values. A 1 is returned for every element of SetB that is in
% SetA, 0 otherwise.
% 
% Example isincluded([1 2], [0 1 1 2 4 5 1 2 4 5]) returns
% [0 1 1 1 0 0 1 1 0 0]

v = zeros (length(Set),1);
for i=1:length(Subset)
    ii = find(Subset(i) == Set);
    v(ii) = 1;
end
v=logical(v); 